import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;

public class PressureView extends JPanel {
	private PressureController controller;
	
	public PressureView( PressureController c ) {
		controller= c;
		setBackground(Color.BLUE);
		setPreferredSize(new Dimension(300,300));
	}
	
	public void paintComponent( Graphics g ) {
		super.paintComponent( g );
		Graphics2D g2= (Graphics2D) g;
		
		double x= 100;
		double height= ((double) controller.getPressure()/1000.0) * 300;
		double width= 10;
		double y= 300 - height;

		Rectangle2D.Double rect= new Rectangle2D.Double( x, y, width, height );
		g2.setPaint( Color.red );
		g2.fill( rect );
	}
}